<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag\Post;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagPostTable;

final class HashtagPostBuilder implements InterfaceHashtagPostSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitHashtagPostSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            HashtagPostTable::HASHTAG_ID => '',
            HashtagPostTable::POST_ID    => '',

            HashtagPostTable::POST_OWNER_USER_ID => '',

            HashtagPostTable::STAMP_REGISTRATION => System::isoDateTime(),
            HashtagPostTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): HashtagPostModel
    {
        return HashtagPostModel::createFromData(
            array(
                // hashtag id

                HashtagPostTable::HASHTAG_ID => $this -> hashtagId

                ?? $this -> defaultValues[HashtagPostTable::HASHTAG_ID],

                // post id

                HashtagPostTable::POST_ID => $this -> postId

                ?? $this -> defaultValues[HashtagPostTable::POST_ID],

                // post owner user id

                HashtagPostTable::POST_OWNER_USER_ID => $this -> postOwnerUserId

                ?? $this -> defaultValues[HashtagPostTable::POST_OWNER_USER_ID],

                // stamp registration

                HashtagPostTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[HashtagPostTable::STAMP_REGISTRATION],

                // stamp last update

                HashtagPostTable::STAMP_LAST_UPDATE  => $this -> stampLastUpdate

                ?? $this -> defaultValues[HashtagPostTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
